c
c NB note to myself: you had trouble for days with this because you
c didn't declare array variables separately after the other variables
c You stupid stupid boy.
c 
c    Graeme Eagles. January 2002. Given a file containing a number
c    of lines, each line bearing the lat, lon and ang of two 
c    Euler poles, will add (or subtract) the second pole from the
c    first one.
c
      program poles_add
      implicit none

      integer maxpoles,npoles,k,i
      character*1 addsub
      parameter (maxpoles=999)

      character*20 polfile,outfile
      double precision fpoles(maxpoles,6)
      double precision outpol(maxpoles,3)
      double precision mat1(3,3)
      double precision mat2(3,3)
      double precision out(3,3)      

      call getarg (1,polfile)
      call getarg (2,outfile)

        WRITE (6,*) '________________________________________________'
        WRITE (6,*) '|                                               |'
        WRITE (6,*) '|    poles_add - add or subtract pairs of       |'
        WRITE (6,*) '| Euler poles given in a file, a pair to a line |'
        WRITE (6,*) '|                                               |'
        WRITE (6,*) '|        USAGE: poles_add inpoles outpoles      |'
        WRITE (6,*) '|                                               |'
        WRITE (6,*) '| Not suitable for babies under 3 million years |'
        WRITE (6,*) '|_______________________________________________|'
        WRITE (6,*) ' '
        WRITE (6,*) ' '

      write(6,*)'Add or subtract second pole from first? (a/s)'
      read(5,*)addsub
      open (unit=10, file=polfile, status='old', err=21)
      open (unit=11, file=outfile, status='unknown', err=22)
      write(11,*)'lon lat ang: Summed poles from ',polfile
 2    format(3f10.3)
      

      call npdec(polfile,maxpoles,npoles)

      call readpoles(polfile,maxpoles,fpoles)


 5    continue
      if (addsub .eq. "a") then
        write(6,*) 'Adding poles......'
        do 10, k=1, npoles
          call pol2mat(fpoles(k,1),fpoles(k,2),
     .                             dble(fpoles(k,3)),mat1)
          call pol2mat(fpoles(k,4),fpoles(k,5),
     .                             dble(fpoles(k,6)),mat2)
          call sumrots(mat1,mat2,out)
          call mat2pol(out,outpol(k,1),outpol(k,2),outpol(k,3))
          write (11,2)outpol(k,2),outpol(k,1),outpol(k,3)
 10      continue
      else if (addsub .eq. "s") then
        write(6,*) 'Subtracting poles......'
        do 20, i=1, npoles
          call pol2mat(fpoles(i,1),fpoles(i,2),
     .                             dble(fpoles(i,3)),mat1)
          call pol2mat(fpoles(i,4),fpoles(i,5),
     .                             dble(-1*(fpoles(i,6))),mat2)
          call sumrots(mat1,mat2,out)
          call mat2pol(out,outpol(i,1),outpol(i,2),outpol(i,3))
          write (11,2)outpol(i,2),outpol(i,1),outpol(i,3)
 20     continue
      else
        write(6,*)'Try again: add (a) or subtract (s)'
        read(5,*)addsub
        go to 5
      end if
      continue

      close(10)
      close(11)
      write(6,*)'All done'
      stop 

 21   stop 'Error opening file. Usage: poles_add IPFILE OPFILE'
 22   stop 'Error opening file. Usage: poles_add IPFILE OPFILE'

      end







C                 Yea, here beginneth the subroutines
c-------------------------------------------------------------------
c subroutine to work out array dimension declarator for npoles
c
       subroutine npdec(polfile,maxpoles,npoles)
c
      implicit none
      integer npoles,i,maxpoles
      double precision fpoles(maxpoles,6)
      character*20 polfile
c      
C Part that counts number of lines in IP poles file to work out npoles
c
      open (unit=10, file=polfile, status='old')
       npoles=0
 5      read(10,*,end=8) fpoles(i,1)
        npoles=npoles+1
        go to 5
 8    continue
      write(6,*)npoles

      close(10)
      return
      end
c

c-------------------------------------------------------------------

c
       subroutine readpoles(polfile,maxpoles,fpoles)

      implicit none
   
      integer i,maxpoles
      double precision fpoles(maxpoles,6)
      character*20 polfile

      open (unit=10, file=polfile, status='old')
9     continue
      i=0

10    continue     
      i=i+1

c         write(6,*)"into readpoles"

         read(10,'(6f13.6)',end=20, err=999) 
     .      FPOLES(i,1), FPOLES(i,2), FPOLES(i,3),
     .      FPOLES(i,4), FPOLES(i,5), FPOLES(i,6)

         write(6,*) 
     .      FPOLES(i,1), FPOLES(i,2), FPOLES(i,3),
     .      FPOLES(i,4), FPOLES(i,5), FPOLES(i,6)

      go to 10

20    continue
      close(10)

      return
999   stop'error opening poles file'
      end


c-------------------------------------------------------------------------
c
      subroutine pol2mat(t,p,a, R)
c
c
c     subroutine pol2mat         Aug 95          A Nankivell
c
c
c     the subroutine creates the 3*3 rotation matrix R for a rotation
c     by angle a about pole with latitude theta=t, longitude phi=p.
c
c     the calculations are carried out in double precision.
c
c          all angles taken in degrees, worked in radians
c
      implicit none

      double precision t, p, a, R(3,3), raddeg
c
      double precision PVEC(3)
C
c       write(6,*) 'In pol2mat'
c       write(6,*) t,p,a
c
c want angle degrees in radians, then multiply by raddeg. 
c Radians in degrees? Divide by raddeg.

      raddeg=0.1745329251994329D-01

      call pnt2vec(t, p, PVEC)
                                                                    
      R(1,1) = PVEC(1)*PVEC(1)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(1,2) = PVEC(1)*PVEC(2)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(1,3) = PVEC(1)*PVEC(3)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(2)*dsin(a*raddeg)

      R(2,1) = PVEC(2)*PVEC(1)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(2,2) = PVEC(2)*PVEC(2)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(2,3) = PVEC(2)*PVEC(3)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(1)*dsin(a*raddeg)

      R(3,1) = PVEC(3)*PVEC(1)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(2)*dsin(a*raddeg)
      R(3,2) = PVEC(3)*PVEC(2)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(1)*dsin(a*raddeg)
      R(3,3) = PVEC(3)*PVEC(3)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)


      return
      end




c------------------------------------------------------------------------

      subroutine sumrots( R1MAT, R2MAT, S)
c
c     the subroutine sums rotations R1 followed by R2 to yield an equivalent 
c     pole, S.
c     the individual rotations are latitude,
c     longitude, angle in decimal degrees.
c     the sign conventions are:
c                  latitude positive north
c                  longitude positive east
c                  angle positive in the right handed sense
c     calculations are carried out in double precision.
c
      implicit none

      double precision R1MAT(3,3), R2MAT(3,3), S(3,3)
c
      integer i, j, k
      double precision sum
c
c       write(6,*) 'In sumrots'
 
      do 10 i = 1 , 3 
        do 20 j = 1 , 3 
          sum = 0.
          do 30 k = 1 ,  3 
            sum =  sum + R2MAT(i,k) * R1MAT(k,j)
30        continue
          S(i,j) = sum
20      continue
10    continue 

c
      return
      end


c----------------------------------------------------------------------




c
      subroutine mat2pol(R,theta,phi,alpha)
c
c
c     subroutine mat2pol          Aug 95          A.Nankivell
c
c
c     the subroutine calculates the rotation axis (latitude theta, longitude phi)
c     and rotation angle (alpha) of the rotation matrix R.
c
c     the calculations are carried out in double precision.
c
c	all angles passed in degrees, processed in radians
c
      implicit none

      double precision raddeg, theta, phi, alpha, R(3,3)
c
      double precision s,u,v,w,z

c       write(6,*) 'In mat2pol'

c
      raddeg=0.1745329251994329D-01

      s = R(1,1) + R(2,2) + R(3,3) - 1

      u = R(3,2) - R(2,3)
      v = R(1,3) - R(3,1)
      w = R(2,1) - R(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

 
      if ( z .eq. 0.) then
        theta = 0.
      else
        theta = (dasin( w / z )/raddeg)
      endif

      phi= (datan2( v , u )/raddeg)
 
      alpha = (datan2 ( z , s )/raddeg)

         
c
      return
      end


c--------------------------------------------------------------

c
      subroutine pnt2vec(plat, plon, V)
c
c     subroutine pnt2vec         Aug 95        Adrian Nankivell
c
c     converts a lat,lon point  to a vector on a unit sphere
c
c     calculations carried out in double precision
c
c     angles received in degrees and processed in radians
c
      implicit none

      double precision raddeg, plat, plon, V(3)

      raddeg=0.1745329251994329D-01
c
c       write(6,*) 'In pnt2vec'

c        write(6,*) plat,plon

      V(3) = dsin(plat*raddeg)
      V(2) = dcos(plat*raddeg) * dsin(plon*raddeg) 
      V(1) = dcos(plat*raddeg) * dcos(plon*raddeg) 

c      already normalised, so return

      return
      end
